@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dscps The DSCP value of the traffic packet to be matched in the current queue, ranging from 0 to 63.
 * @property id
 * @property interRegionTrafficQosQueueDescription The description information of the traffic scheduling policy.
 * @property interRegionTrafficQosQueueId The ID of the resource.
 * @property interRegionTrafficQosQueueName The name of the traffic scheduling policy.
 * @property remainBandwidthPercent The percentage of cross-region bandwidth that the current queue can use.
 * @property status The status of the traffic scheduling policy. -**Creating**: The function is being created.-**Active**: available.-**Modifying**: is being modified.-**Deleting**: Deleted.-**Deleted**: Deleted.
 * @property trafficQosPolicyId The ID of the traffic scheduling policy.
 */
public data class GetInterRegionTrafficQosQueuesQueue(
    public val dscps: List<String>,
    public val id: String,
    public val interRegionTrafficQosQueueDescription: String,
    public val interRegionTrafficQosQueueId: String,
    public val interRegionTrafficQosQueueName: String,
    public val remainBandwidthPercent: Int,
    public val status: String,
    public val trafficQosPolicyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetInterRegionTrafficQosQueuesQueue): GetInterRegionTrafficQosQueuesQueue = GetInterRegionTrafficQosQueuesQueue(
            dscps = javaType.dscps().map({ args0 -> args0 }),
            id = javaType.id(),
            interRegionTrafficQosQueueDescription = javaType.interRegionTrafficQosQueueDescription(),
            interRegionTrafficQosQueueId = javaType.interRegionTrafficQosQueueId(),
            interRegionTrafficQosQueueName = javaType.interRegionTrafficQosQueueName(),
            remainBandwidthPercent = javaType.remainBandwidthPercent(),
            status = javaType.status(),
            trafficQosPolicyId = javaType.trafficQosPolicyId(),
        )
    }
}
