@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInterRegionTrafficQosQueues.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Inter Region Traffic Qos Queue IDs.
 * @property nameRegex
 * @property names A list of name of Inter Region Traffic Qos Queues.
 * @property outputFile
 * @property queues A list of Inter Region Traffic Qos Queue Entries. Each element contains the following attributes:
 * @property trafficQosPolicyId The ID of the traffic scheduling policy.
 */
public data class GetInterRegionTrafficQosQueuesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val queues: List<GetInterRegionTrafficQosQueuesQueue>,
    public val trafficQosPolicyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetInterRegionTrafficQosQueuesResult): GetInterRegionTrafficQosQueuesResult = GetInterRegionTrafficQosQueuesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            queues = javaType.queues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetInterRegionTrafficQosQueuesQueue.Companion.toKotlin(args0)
                })
            }),
            trafficQosPolicyId = javaType.trafficQosPolicyId(),
        )
    }
}
