@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPrivateZones.
 * @property cenId The ID of the CEN instance.
 * @property hostRegionId The service region. The service region is the target region of the PrivateZone service accessed through CEN.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN private zone IDs. Each element format as `<cen_id>:<access_region_id>`.
 * **NOTE:** Before 1.162.0, each element same as `access_region_id`.
 * @property outputFile
 * @property status The status of the PrivateZone service.
 * @property zones A list of CEN private zones. Each element contains the following attributes:
 */
public data class GetPrivateZonesResult(
    public val cenId: String,
    public val hostRegionId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val zones: List<GetPrivateZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetPrivateZonesResult): GetPrivateZonesResult = GetPrivateZonesResult(
            cenId = javaType.cenId(),
            hostRegionId = javaType.hostRegionId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            zones = javaType.zones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetPrivateZonesZone.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
