@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessRegionId The access region. The access region is the region of the cloud resource that accesses the PrivateZone service through CEN.
 * @property cenId The ID of the CEN instance.
 * @property hostRegionId The service region. The service region is the target region of the PrivateZone service accessed through CEN.
 * @property hostVpcId The VPC that belongs to the service region.
 * @property id The ID of the private zone. It formats as `<cen_id>:<access_region_id>`.
 * @property privateZoneDnsServers The DNS IP addresses of the PrivateZone service.
 * @property status The status of the PrivateZone service, including `Creating`, `Active` and `Deleting`.
 */
public data class GetPrivateZonesZone(
    public val accessRegionId: String,
    public val cenId: String,
    public val hostRegionId: String,
    public val hostVpcId: String,
    public val id: String,
    public val privateZoneDnsServers: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetPrivateZonesZone): GetPrivateZonesZone = GetPrivateZonesZone(
            accessRegionId = javaType.accessRegionId(),
            cenId = javaType.cenId(),
            hostRegionId = javaType.hostRegionId(),
            hostVpcId = javaType.hostVpcId(),
            id = javaType.id(),
            privateZoneDnsServers = javaType.privateZoneDnsServers(),
            status = javaType.status(),
        )
    }
}
