@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The destination CIDR block of the route entry.
 * @property nextHopId ID of the next hop.
 * @property nextHopRegionId ID of the region where the next hop is located.
 * @property nextHopType Type of the next hop.
 * @property type Type of the route entry.
 */
public data class GetRegionRouteEntriesEntry(
    public val cidrBlock: String,
    public val nextHopId: String,
    public val nextHopRegionId: String,
    public val nextHopType: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRegionRouteEntriesEntry): GetRegionRouteEntriesEntry = GetRegionRouteEntriesEntry(
            cidrBlock = javaType.cidrBlock(),
            nextHopId = javaType.nextHopId(),
            nextHopRegionId = javaType.nextHopRegionId(),
            nextHopType = javaType.nextHopType(),
            type = javaType.type(),
        )
    }
}
