@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRegionRouteEntries.
 * @property entries A list of CEN Route Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property outputFile
 * @property regionId
 */
public data class GetRegionRouteEntriesResult(
    public val entries: List<GetRegionRouteEntriesEntry>,
    public val id: String,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val regionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRegionRouteEntriesResult): GetRegionRouteEntriesResult = GetRegionRouteEntriesResult(
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetRegionRouteEntriesEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            regionId = javaType.regionId(),
        )
    }
}
