@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cidrBlock The destination CIDR block of the route entry to query.
 * @property conflicts A list of conflicted Route Entries. Each element contains the following attributes:
 * @property nextHopId ID of the next hop.
 * @property nextHopType Type of the next hop, including "Instance", "HaVip" and "RouterInterface".
 * @property operationalMode Whether to allow the route entry to be published or removed to or from CEN.
 * @property publishStatus The publish status of the route entry in CEN, including "Published" and "NonPublished".
 * @property routeTableId ID of the route table of the VPC or VBR.
 * @property routeType Type of the route entry, including "System", "Custom" and "BGP".
 */
public data class GetRouteEntriesEntry(
    public val cidrBlock: String,
    public val conflicts: List<GetRouteEntriesEntryConflict>,
    public val nextHopId: String,
    public val nextHopType: String,
    public val operationalMode: Boolean,
    public val publishStatus: String,
    public val routeTableId: String,
    public val routeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRouteEntriesEntry): GetRouteEntriesEntry = GetRouteEntriesEntry(
            cidrBlock = javaType.cidrBlock(),
            conflicts = javaType.conflicts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetRouteEntriesEntryConflict.Companion.toKotlin(args0)
                })
            }),
            nextHopId = javaType.nextHopId(),
            nextHopType = javaType.nextHopType(),
            operationalMode = javaType.operationalMode(),
            publishStatus = javaType.publishStatus(),
            routeTableId = javaType.routeTableId(),
            routeType = javaType.routeType(),
        )
    }
}
