@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The destination CIDR block of the route entry to query.
 * @property instanceId ID of the CEN instance.
 * @property instanceType The type of the CEN child instance.
 * @property regionId ID of the region where the conflicted route entry is located.
 * @property status Reasons of exceptions.
 */
public data class GetRouteEntriesEntryConflict(
    public val cidrBlock: String,
    public val instanceId: String,
    public val instanceType: String,
    public val regionId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRouteEntriesEntryConflict): GetRouteEntriesEntryConflict = GetRouteEntriesEntryConflict(
            cidrBlock = javaType.cidrBlock(),
            instanceId = javaType.instanceId(),
            instanceType = javaType.instanceType(),
            regionId = javaType.regionId(),
            status = javaType.status(),
        )
    }
}
