@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouteEntries.
 * @property cidrBlock The destination CIDR block of the conflicted route entry.
 * @property entries A list of CEN Route Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId ID of the CEN child instance.
 * @property outputFile
 * @property routeTableId ID of the route table.
 */
public data class GetRouteEntriesResult(
    public val cidrBlock: String? = null,
    public val entries: List<GetRouteEntriesEntry>,
    public val id: String,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val routeTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRouteEntriesResult): GetRouteEntriesResult = GetRouteEntriesResult(
            cidrBlock = javaType.cidrBlock().map({ args0 -> args0 }).orElse(null),
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetRouteEntriesEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            routeTableId = javaType.routeTableId(),
        )
    }
}
