@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property asPathMatchMode A match statement. It indicates the mode in which the as-path attribute is matched.
 * @property cenId The ID of the CEN instance.
 * @property cenRegionId The ID of the region to which the CEN instance belongs.
 * @property cidrMatchMode A match statement. It indicates the mode in which the prefix attribute is matched.
 * @property communityMatchMode A match statement. It indicates the mode in which the community attribute is matched.
 * @property communityOperateMode An action statement. It indicates the mode in which the community attribute is operated.
 * @property description The description of the route map.
 * @property destinationChildInstanceTypes A match statement that indicates the list of IDs of the destination instances.
 * @property destinationCidrBlocks A match statement that indicates the prefix list.
 * @property destinationInstanceIds A match statement that indicates the list of IDs of the destination instances.
 * @property destinationInstanceIdsReverseMatch Indicates whether to enable the reverse match method of the DestinationInstanceIds match condition.
 * @property destinationRouteTableIds A match statement that indicates the list of IDs of the destination route tables.
 * @property id The ID of the route map. It formats as `<cen_id>:<route_map_id>`. Before 1.161.0, it is `route_map_id`.
 * @property mapResult The action that is performed to a route if the route meets all the match conditions.
 * @property matchAsns A match statement that indicates the As path list.
 * @property matchCommunitySets A match statement that indicates the community set.
 * @property nextPriority The priority of the next route map that is associated with the current route map.
 * @property operateCommunitySets An action statement that operates the community attribute.
 * @property preference An action statement that modifies the preference of the route.
 * @property prependAsPaths Indicates AS Path prepending when a regional gateway receives or publishes a route.
 * @property priority The priority of the route map.
 * @property routeMapId The ID of the route map.
 * @property routeTypes A match statement that indicates the list of route types.
 * @property sourceChildInstanceTypes A match statement that indicates the list of IDs of the source instances.
 * @property sourceInstanceIds A match statement that indicates the list of IDs of the source instances.
 * @property sourceInstanceIdsReverseMatch Indicates whether to enable the reverse match method of the SourceInstanceIds match condition.
 * @property sourceRegionIds A match statement that indicates the list of IDs of the source regions.
 * @property sourceRouteTableIds A match statement that indicates the list of IDs of the source route tables.
 * @property status The status of the route map, including `Creating`, `Active` and `Deleting`.
 * @property transmitDirection The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
 */
public data class GetRouteMapsMap(
    public val asPathMatchMode: String,
    public val cenId: String,
    public val cenRegionId: String,
    public val cidrMatchMode: String,
    public val communityMatchMode: String,
    public val communityOperateMode: String,
    public val description: String,
    public val destinationChildInstanceTypes: List<String>,
    public val destinationCidrBlocks: List<String>,
    public val destinationInstanceIds: List<String>,
    public val destinationInstanceIdsReverseMatch: Boolean,
    public val destinationRouteTableIds: List<String>,
    public val id: String,
    public val mapResult: String,
    public val matchAsns: List<String>,
    public val matchCommunitySets: List<String>,
    public val nextPriority: Int,
    public val operateCommunitySets: List<String>,
    public val preference: Int,
    public val prependAsPaths: List<String>,
    public val priority: Int,
    public val routeMapId: String,
    public val routeTypes: List<String>,
    public val sourceChildInstanceTypes: List<String>,
    public val sourceInstanceIds: List<String>,
    public val sourceInstanceIdsReverseMatch: Boolean,
    public val sourceRegionIds: List<String>,
    public val sourceRouteTableIds: List<String>,
    public val status: String,
    public val transmitDirection: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRouteMapsMap): GetRouteMapsMap = GetRouteMapsMap(
            asPathMatchMode = javaType.asPathMatchMode(),
            cenId = javaType.cenId(),
            cenRegionId = javaType.cenRegionId(),
            cidrMatchMode = javaType.cidrMatchMode(),
            communityMatchMode = javaType.communityMatchMode(),
            communityOperateMode = javaType.communityOperateMode(),
            description = javaType.description(),
            destinationChildInstanceTypes = javaType.destinationChildInstanceTypes().map({ args0 -> args0 }),
            destinationCidrBlocks = javaType.destinationCidrBlocks().map({ args0 -> args0 }),
            destinationInstanceIds = javaType.destinationInstanceIds().map({ args0 -> args0 }),
            destinationInstanceIdsReverseMatch = javaType.destinationInstanceIdsReverseMatch(),
            destinationRouteTableIds = javaType.destinationRouteTableIds().map({ args0 -> args0 }),
            id = javaType.id(),
            mapResult = javaType.mapResult(),
            matchAsns = javaType.matchAsns().map({ args0 -> args0 }),
            matchCommunitySets = javaType.matchCommunitySets().map({ args0 -> args0 }),
            nextPriority = javaType.nextPriority(),
            operateCommunitySets = javaType.operateCommunitySets().map({ args0 -> args0 }),
            preference = javaType.preference(),
            prependAsPaths = javaType.prependAsPaths().map({ args0 -> args0 }),
            priority = javaType.priority(),
            routeMapId = javaType.routeMapId(),
            routeTypes = javaType.routeTypes().map({ args0 -> args0 }),
            sourceChildInstanceTypes = javaType.sourceChildInstanceTypes().map({ args0 -> args0 }),
            sourceInstanceIds = javaType.sourceInstanceIds().map({ args0 -> args0 }),
            sourceInstanceIdsReverseMatch = javaType.sourceInstanceIdsReverseMatch(),
            sourceRegionIds = javaType.sourceRegionIds().map({ args0 -> args0 }),
            sourceRouteTableIds = javaType.sourceRouteTableIds().map({ args0 -> args0 }),
            status = javaType.status(),
            transmitDirection = javaType.transmitDirection(),
        )
    }
}
