@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouteMaps.
 * @property cenId The ID of the CEN instance.
 * @property cenRegionId The ID of the region to which the CEN instance belongs.
 * @property descriptionRegex
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN route map IDs. Each item formats as `<cen_id>:<route_map_id>`. Before 1.161.0, its element is `route_map_id`.
 * @property maps A list of CEN instances. Each element contains the following attributes:
 * @property outputFile
 * @property status The status of the route map.
 * @property transmitDirection The direction in which the route map is applied.
 */
public data class GetRouteMapsResult(
    public val cenId: String,
    public val cenRegionId: String? = null,
    public val descriptionRegex: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val maps: List<GetRouteMapsMap>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transmitDirection: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRouteMapsResult): GetRouteMapsResult = GetRouteMapsResult(
            cenId = javaType.cenId(),
            cenRegionId = javaType.cenRegionId().map({ args0 -> args0 }).orElse(null),
            descriptionRegex = javaType.descriptionRegex().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            maps = javaType.maps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetRouteMapsMap.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transmitDirection = javaType.transmitDirection().map({ args0 -> args0 }).orElse(null),
        )
    }
}
