@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouteServices.
 * @property accessRegionId The region of the network instances that access the cloud services.
 * @property cenId The ID of the CEN instance.
 * @property host The domain name or IP address of the cloud service.
 * @property hostRegionId The region of the cloud service.
 * @property hostVpcId The VPC associated with the cloud service.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN Route Service IDs.
 * @property outputFile
 * @property services A list of CEN Route Services. Each element contains the following attributes:
 * @property status The status of the cloud service.
 */
public data class GetRouteServicesResult(
    public val accessRegionId: String? = null,
    public val cenId: String,
    public val host: String? = null,
    public val hostRegionId: String? = null,
    public val hostVpcId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val services: List<GetRouteServicesService>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRouteServicesResult): GetRouteServicesResult = GetRouteServicesResult(
            accessRegionId = javaType.accessRegionId().map({ args0 -> args0 }).orElse(null),
            cenId = javaType.cenId(),
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            hostRegionId = javaType.hostRegionId().map({ args0 -> args0 }).orElse(null),
            hostVpcId = javaType.hostVpcId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            services = javaType.services().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetRouteServicesService.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
