@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessRegionId The region of the network instances that access the cloud services.
 * @property cenId The ID of the CEN instance.
 * @property cidrs The IP address of the cloud service.
 * @property description The description of the cloud service.
 * @property host The domain name or IP address of the cloud service.
 * @property hostRegionId The region of the cloud service.
 * @property hostVpcId The VPC associated with the cloud service.
 * @property id The ID of the route service.
 * @property status The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
 * @property updateInterval The update interval. Default value: 5. The value cannot be modified.
 */
public data class GetRouteServicesService(
    public val accessRegionId: String,
    public val cenId: String,
    public val cidrs: List<String>,
    public val description: String,
    public val host: String,
    public val hostRegionId: String,
    public val hostVpcId: String,
    public val id: String,
    public val status: String,
    public val updateInterval: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetRouteServicesService): GetRouteServicesService = GetRouteServicesService(
            accessRegionId = javaType.accessRegionId(),
            cenId = javaType.cenId(),
            cidrs = javaType.cidrs().map({ args0 -> args0 }),
            description = javaType.description(),
            host = javaType.host(),
            hostRegionId = javaType.hostRegionId(),
            hostVpcId = javaType.hostVpcId(),
            id = javaType.id(),
            status = javaType.status(),
            updateInterval = javaType.updateInterval(),
        )
    }
}
