@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the Traffic Marking Policy.
 * @property id The ID of the resource. The value is formatted `<transit_router_id>:<traffic_marking_policy_id>`.
 * @property markingDscp The DSCP(Differentiated Services Code Point) of the Traffic Marking Policy.
 * @property priority The Priority of the Traffic Marking Policy.
 * @property status The status of the resource.
 * @property trafficMarkingPolicyId The ID of the Traffic Marking Policy.
 * @property trafficMarkingPolicyName The name of the Traffic Marking Policy.
 * @property transitRouterId The ID of the transit router.
 */
public data class GetTrafficMarkingPoliciesPolicy(
    public val description: String,
    public val id: String,
    public val markingDscp: Int,
    public val priority: Int,
    public val status: String,
    public val trafficMarkingPolicyId: String,
    public val trafficMarkingPolicyName: String,
    public val transitRouterId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTrafficMarkingPoliciesPolicy): GetTrafficMarkingPoliciesPolicy = GetTrafficMarkingPoliciesPolicy(
            description = javaType.description(),
            id = javaType.id(),
            markingDscp = javaType.markingDscp(),
            priority = javaType.priority(),
            status = javaType.status(),
            trafficMarkingPolicyId = javaType.trafficMarkingPolicyId(),
            trafficMarkingPolicyName = javaType.trafficMarkingPolicyName(),
            transitRouterId = javaType.transitRouterId(),
        )
    }
}
