@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouteTableAggregations.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Transit Route Table Aggregation names.
 * @property outputFile
 * @property status The status of the Transit Route Table Aggregation.
 * @property transitRouteTableAggregationCidr The destination CIDR block of the aggregate route.
 * @property transitRouteTableAggregations A list of Cen Transit Route Table Aggregations. Each element contains the following attributes:
 * @property transitRouteTableId The ID of the route table of the Enterprise Edition transit router.
 */
public data class GetTransitRouteTableAggregationsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouteTableAggregationCidr: String? = null,
    public val transitRouteTableAggregations: List<GetTransitRouteTableAggregationsTransitRouteTableAggregation>,
    public val transitRouteTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouteTableAggregationsResult): GetTransitRouteTableAggregationsResult = GetTransitRouteTableAggregationsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouteTableAggregationCidr = javaType.transitRouteTableAggregationCidr().map({ args0 ->
                args0
            }).orElse(null),
            transitRouteTableAggregations = javaType.transitRouteTableAggregations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouteTableAggregationsTransitRouteTableAggregation.Companion.toKotlin(args0)
                })
            }),
            transitRouteTableId = javaType.transitRouteTableId(),
        )
    }
}
