@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Transit Route Table Aggregation. It formats as `<transit_route_table_id>:<transit_route_table_aggregation_cidr>`.
 * @property routeType The route type of the aggregate route.
 * @property status The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
 * @property transitRouteTableAggregationCidr The destination CIDR block of the aggregate route.
 * @property transitRouteTableAggregationDescription The description of the aggregate route.
 * @property transitRouteTableAggregationName The name of the aggregate route.
 * @property transitRouteTableAggregationScope The scope of networks that you want to advertise the aggregate route.
 * @property transitRouteTableId The ID of the route table of the Enterprise Edition transit router.
 */
public data class GetTransitRouteTableAggregationsTransitRouteTableAggregation(
    public val id: String,
    public val routeType: String,
    public val status: String,
    public val transitRouteTableAggregationCidr: String,
    public val transitRouteTableAggregationDescription: String,
    public val transitRouteTableAggregationName: String,
    public val transitRouteTableAggregationScope: String,
    public val transitRouteTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouteTableAggregationsTransitRouteTableAggregation): GetTransitRouteTableAggregationsTransitRouteTableAggregation =
            GetTransitRouteTableAggregationsTransitRouteTableAggregation(
                id = javaType.id(),
                routeType = javaType.routeType(),
                status = javaType.status(),
                transitRouteTableAggregationCidr = javaType.transitRouteTableAggregationCidr(),
                transitRouteTableAggregationDescription = javaType.transitRouteTableAggregationDescription(),
                transitRouteTableAggregationName = javaType.transitRouteTableAggregationName(),
                transitRouteTableAggregationScope = javaType.transitRouteTableAggregationScope(),
                transitRouteTableId = javaType.transitRouteTableId(),
            )
    }
}
