@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availableZones (Available since v1.225.0) The list of available zones.
 * @property masterZones The list of primary zones.
 * @property slaveZones The list of secondary zones.
 * @property supportMulticast Specifies whether to query only the zones in which the multicast feature is supported.
 */
public data class GetTransitRouterAvailableResourcesResource(
    public val availableZones: List<String>,
    public val masterZones: List<String>,
    public val slaveZones: List<String>,
    public val supportMulticast: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterAvailableResourcesResource): GetTransitRouterAvailableResourcesResource = GetTransitRouterAvailableResourcesResource(
            availableZones = javaType.availableZones().map({ args0 -> args0 }),
            masterZones = javaType.masterZones().map({ args0 -> args0 }),
            slaveZones = javaType.slaveZones().map({ args0 -> args0 }),
            supportMulticast = javaType.supportMulticast(),
        )
    }
}
