@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterAvailableResources.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property resources A list of Cen Transit Router Available Resources. Each element contains the following attributes:
 * @property supportMulticast (Available since v1.225.0) Indicates whether the zone supports the multicast feature.
 */
public data class GetTransitRouterAvailableResourcesResult(
    public val id: String,
    public val outputFile: String? = null,
    public val resources: List<GetTransitRouterAvailableResourcesResource>,
    public val supportMulticast: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterAvailableResourcesResult): GetTransitRouterAvailableResourcesResult = GetTransitRouterAvailableResourcesResult(
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterAvailableResourcesResource.Companion.toKotlin(args0)
                })
            }),
            supportMulticast = javaType.supportMulticast().map({ args0 -> args0 }).orElse(null),
        )
    }
}
