@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidr The cidr of the transit router.
 * @property description The description of the transit router.
 * @property family The type of the transit router cidr.
 * @property id The ID of the Cen Transit Router Cidr. It formats as `<transit_router_id>:<transit_router_cidr_id>`.
 * @property publishCidrRoute Whether to allow automatically adding Transit Router Cidr in Transit Router Route Table.
 * @property transitRouterCidrId The ID of the transit router cidr.
 * @property transitRouterCidrName The name of the transit router.
 * @property transitRouterId The ID of the transit router.
 */
public data class GetTransitRouterCidrsCidr(
    public val cidr: String,
    public val description: String,
    public val family: String,
    public val id: String,
    public val publishCidrRoute: Boolean,
    public val transitRouterCidrId: String,
    public val transitRouterCidrName: String,
    public val transitRouterId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterCidrsCidr): GetTransitRouterCidrsCidr = GetTransitRouterCidrsCidr(
            cidr = javaType.cidr(),
            description = javaType.description(),
            family = javaType.family(),
            id = javaType.id(),
            publishCidrRoute = javaType.publishCidrRoute(),
            transitRouterCidrId = javaType.transitRouterCidrId(),
            transitRouterCidrName = javaType.transitRouterCidrName(),
            transitRouterId = javaType.transitRouterId(),
        )
    }
}
