@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterCidrs.
 * @property cidrs
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property transitRouterCidrId
 * @property transitRouterId
 */
public data class GetTransitRouterCidrsResult(
    public val cidrs: List<GetTransitRouterCidrsCidr>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val transitRouterCidrId: String? = null,
    public val transitRouterId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterCidrsResult): GetTransitRouterCidrsResult = GetTransitRouterCidrsResult(
            cidrs = javaType.cidrs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterCidrsCidr.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            transitRouterCidrId = javaType.transitRouterCidrId().map({ args0 -> args0 }).orElse(null),
            transitRouterId = javaType.transitRouterId(),
        )
    }
}
