@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Transit Router Multicast Domain Association. It formats as `<transit_router_multicast_domain_id>:<transit_router_attachment_id>:<vswitch_id>`.
 * @property resourceId The ID of the resource associated with the multicast domain.
 * @property resourceOwnerId The ID of the Alibaba Cloud account to which the resource associated with the multicast domain belongs.
 * @property resourceType The type of resource associated with the multicast domain. Valid Value: `VPC`.
 * @property status The status of the associated resource. Valid Value: `Associated`, `Associating`, `Dissociating`.
 * @property transitRouterAttachmentId The ID of the network instance connection.
 * @property transitRouterMulticastDomainId The ID of the multicast domain.
 * @property vswitchId The ID of the vSwitch.
 */
public data class GetTransitRouterMulticastDomainAssociationsAssociation(
    public val id: String,
    public val resourceId: String,
    public val resourceOwnerId: Int,
    public val resourceType: String,
    public val status: String,
    public val transitRouterAttachmentId: String,
    public val transitRouterMulticastDomainId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainAssociationsAssociation): GetTransitRouterMulticastDomainAssociationsAssociation =
            GetTransitRouterMulticastDomainAssociationsAssociation(
                id = javaType.id(),
                resourceId = javaType.resourceId(),
                resourceOwnerId = javaType.resourceOwnerId(),
                resourceType = javaType.resourceType(),
                status = javaType.status(),
                transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
                transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
                vswitchId = javaType.vswitchId(),
            )
    }
}
