@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterMulticastDomainAssociations.
 * @property associations A list of Cen Transit Router Multicast Domain Associations. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property resourceId The ID of the resource associated with the multicast domain.
 * @property resourceType The type of resource associated with the multicast domain.
 * @property status The status of the associated resource.
 * @property transitRouterAttachmentId The ID of the network instance connection.
 * @property transitRouterMulticastDomainId The ID of the multicast domain.
 * @property vswitchId The ID of the vSwitch.
 */
public data class GetTransitRouterMulticastDomainAssociationsResult(
    public val associations: List<GetTransitRouterMulticastDomainAssociationsAssociation>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val resourceId: String? = null,
    public val resourceType: String? = null,
    public val status: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterMulticastDomainId: String,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainAssociationsResult): GetTransitRouterMulticastDomainAssociationsResult =
            GetTransitRouterMulticastDomainAssociationsResult(
                associations = javaType.associations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainAssociationsAssociation.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
                resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                transitRouterAttachmentId = javaType.transitRouterAttachmentId().map({ args0 ->
                    args0
                }).orElse(null),
                transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
                vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
