@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupIpAddress The IP address of the multicast group to which the multicast member belongs. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
 * @property id The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<network_interface_id>`.
 * @property networkInterfaceId The ID of the ENI.
 * @property status The status of the resource
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
 * @property vpcId The VPC to which the ENI of the multicast member belongs. This field is mandatory for VPCs owned by another accounts.
 */
public data class GetTransitRouterMulticastDomainMembersMember(
    public val groupIpAddress: String,
    public val id: String,
    public val networkInterfaceId: String,
    public val status: String,
    public val transitRouterMulticastDomainId: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainMembersMember): GetTransitRouterMulticastDomainMembersMember = GetTransitRouterMulticastDomainMembersMember(
            groupIpAddress = javaType.groupIpAddress(),
            id = javaType.id(),
            networkInterfaceId = javaType.networkInterfaceId(),
            status = javaType.status(),
            transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
            vpcId = javaType.vpcId(),
        )
    }
}
