@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterMulticastDomainMembers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property members A list of Transit Router Multicast Domain Member Entries. Each element contains the following attributes:
 * @property networkInterfaceId ENI ID of multicast member.
 * @property outputFile
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
 */
public data class GetTransitRouterMulticastDomainMembersResult(
    public val id: String,
    public val ids: List<String>,
    public val members: List<GetTransitRouterMulticastDomainMembersMember>,
    public val networkInterfaceId: String? = null,
    public val outputFile: String? = null,
    public val transitRouterMulticastDomainId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainMembersResult): GetTransitRouterMulticastDomainMembersResult = GetTransitRouterMulticastDomainMembersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            members = javaType.members().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainMembersMember.Companion.toKotlin(args0)
                })
            }),
            networkInterfaceId = javaType.networkInterfaceId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
        )
    }
}
