@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupIpAddress The IP address of the multicast group to which the multicast member belongs. Value range: **224.0.0.1** to **239.255.255.254**.If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you in the current multicast domain.
 * @property id The `key` of the resource supplied above.The value is formulated as `<transit_router_multicast_domain_id>:<group_ip_address>:<peer_transit_router_multicast_domain_id>`.
 * @property peerTransitRouterMulticastDomainId The multicast domain ID of the peer transit router.
 * @property status The status of the resource
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
 */
public data class GetTransitRouterMulticastDomainPeerMembersMember(
    public val groupIpAddress: String,
    public val id: String,
    public val peerTransitRouterMulticastDomainId: String,
    public val status: String,
    public val transitRouterMulticastDomainId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainPeerMembersMember): GetTransitRouterMulticastDomainPeerMembersMember =
            GetTransitRouterMulticastDomainPeerMembersMember(
                groupIpAddress = javaType.groupIpAddress(),
                id = javaType.id(),
                peerTransitRouterMulticastDomainId = javaType.peerTransitRouterMulticastDomainId(),
                status = javaType.status(),
                transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
            )
    }
}
