@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterMulticastDomainPeerMembers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property members A list of Transit Router Multicast Domain Peer Member Entries. Each element contains the following attributes:
 * @property outputFile
 * @property peerTransitRouterMulticastDomains
 * @property resourceId
 * @property resourceType
 * @property transitRouterAttachmentId
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
 */
public data class GetTransitRouterMulticastDomainPeerMembersResult(
    public val id: String,
    public val ids: List<String>,
    public val members: List<GetTransitRouterMulticastDomainPeerMembersMember>,
    public val outputFile: String? = null,
    public val peerTransitRouterMulticastDomains: List<String>? = null,
    public val resourceId: String? = null,
    public val resourceType: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterMulticastDomainId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainPeerMembersResult): GetTransitRouterMulticastDomainPeerMembersResult =
            GetTransitRouterMulticastDomainPeerMembersResult(
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                members = javaType.members().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainPeerMembersMember.Companion.toKotlin(args0)
                    })
                }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                peerTransitRouterMulticastDomains = javaType.peerTransitRouterMulticastDomains().map({ args0 ->
                    args0
                }),
                resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
                resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
                transitRouterAttachmentId = javaType.transitRouterAttachmentId().map({ args0 ->
                    args0
                }).orElse(null),
                transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
            )
    }
}
