@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterMulticastDomainSources.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property sources A list of Transit Router Multicast Domain Source Entries. Each element contains the following attributes:
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast source belongs.
 */
public data class GetTransitRouterMulticastDomainSourcesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val sources: List<GetTransitRouterMulticastDomainSourcesSource>,
    public val transitRouterMulticastDomainId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainSourcesResult): GetTransitRouterMulticastDomainSourcesResult = GetTransitRouterMulticastDomainSourcesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainSourcesSource.Companion.toKotlin(args0)
                })
            }),
            transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
        )
    }
}
