@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupIpAddress The IP address of the multicast group to which the multicast source belongs. Value range: **224.0.0.1** to **239.255.255.254**. If the multicast group you specified does not exist in the current multicast domain, the system will automatically create a new multicast group for you.
 * @property id The id of the resource.
 * @property networkInterfaceId ENI ID of the multicast source.
 * @property status The status of the resource.
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast source belongs.
 * @property vpcId The VPC to which the ENI of the multicast source belongs. This field is mandatory for VPCs that is owned by another accounts.
 */
public data class GetTransitRouterMulticastDomainSourcesSource(
    public val groupIpAddress: String,
    public val id: String,
    public val networkInterfaceId: String,
    public val status: String,
    public val transitRouterMulticastDomainId: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainSourcesSource): GetTransitRouterMulticastDomainSourcesSource = GetTransitRouterMulticastDomainSourcesSource(
            groupIpAddress = javaType.groupIpAddress(),
            id = javaType.id(),
            networkInterfaceId = javaType.networkInterfaceId(),
            status = javaType.status(),
            transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
            vpcId = javaType.vpcId(),
        )
    }
}
