@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Transit Router Multicast Domain.
 * @property status The status of the multicast domain. Valid Value: `Active`.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterMulticastDomainDescription The description of the Transit Router Multicast Domain.
 * @property transitRouterMulticastDomainId The ID of the multicast domain.
 * @property transitRouterMulticastDomainName The name of the Transit Router Multicast Domain.
 */
public data class GetTransitRouterMulticastDomainsDomain(
    public val id: String,
    public val status: String,
    public val transitRouterId: String,
    public val transitRouterMulticastDomainDescription: String,
    public val transitRouterMulticastDomainId: String,
    public val transitRouterMulticastDomainName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainsDomain): GetTransitRouterMulticastDomainsDomain = GetTransitRouterMulticastDomainsDomain(
            id = javaType.id(),
            status = javaType.status(),
            transitRouterId = javaType.transitRouterId(),
            transitRouterMulticastDomainDescription = javaType.transitRouterMulticastDomainDescription(),
            transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId(),
            transitRouterMulticastDomainName = javaType.transitRouterMulticastDomainName(),
        )
    }
}
