@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterMulticastDomains.
 * @property domains A list of Cen Transit Router Multicast Domains. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Transit Router Multicast Domain names.
 * @property outputFile
 * @property status The status of the Transit Router Multicast Domain.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterMulticastDomainId The ID of the Transit Router Multicast Domain.
 */
public data class GetTransitRouterMulticastDomainsResult(
    public val domains: List<GetTransitRouterMulticastDomainsDomain>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String,
    public val transitRouterMulticastDomainId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterMulticastDomainsResult): GetTransitRouterMulticastDomainsResult = GetTransitRouterMulticastDomainsResult(
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterMulticastDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterId = javaType.transitRouterId(),
            transitRouterMulticastDomainId = javaType.transitRouterMulticastDomainId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
