@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoPublishRouteEnabled Auto publish route enabled.
 * @property bandwidth The bandwidth of the bandwidth package.
 * @property cenBandwidthPackageId ID of the CEN bandwidth package.
 * @property geographicSpanId ID of the geographic.
 * @property id The ID of CEN Transit Router peer attachments.
 * @property peerTransitRouterId ID of the peer transit router.
 * @property peerTransitRouterOwnerId Owner ID of the peer transit router.
 * @property peerTransitRouterRegionId Region ID of the peer transit router.
 * @property resourceType Type of the resource.
 * @property status The status of CEN Transit Router peer attachment. Valid values `Attached`, `Attaching` and `Detaching`.
 * @property transitRouterAttachmentDescription The description of CEN Transit Router peer attachments.
 * @property transitRouterAttachmentId The ID of CEN Transit Router peer attachments.
 * @property transitRouterAttachmentName Name of the transit router attachment.
 * @property transitRouterId The ID of transit router.
 */
public data class GetTransitRouterPeerAttachmentsAttachment(
    public val autoPublishRouteEnabled: Boolean,
    public val bandwidth: Int,
    public val cenBandwidthPackageId: String,
    public val geographicSpanId: String,
    public val id: String,
    public val peerTransitRouterId: String,
    public val peerTransitRouterOwnerId: String,
    public val peerTransitRouterRegionId: String,
    public val resourceType: String,
    public val status: String,
    public val transitRouterAttachmentDescription: String,
    public val transitRouterAttachmentId: String,
    public val transitRouterAttachmentName: String,
    public val transitRouterId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterPeerAttachmentsAttachment): GetTransitRouterPeerAttachmentsAttachment = GetTransitRouterPeerAttachmentsAttachment(
            autoPublishRouteEnabled = javaType.autoPublishRouteEnabled(),
            bandwidth = javaType.bandwidth(),
            cenBandwidthPackageId = javaType.cenBandwidthPackageId(),
            geographicSpanId = javaType.geographicSpanId(),
            id = javaType.id(),
            peerTransitRouterId = javaType.peerTransitRouterId(),
            peerTransitRouterOwnerId = javaType.peerTransitRouterOwnerId(),
            peerTransitRouterRegionId = javaType.peerTransitRouterRegionId(),
            resourceType = javaType.resourceType(),
            status = javaType.status(),
            transitRouterAttachmentDescription = javaType.transitRouterAttachmentDescription(),
            transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
            transitRouterAttachmentName = javaType.transitRouterAttachmentName(),
            transitRouterId = javaType.transitRouterId(),
        )
    }
}
