@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterPeerAttachments.
 * @property attachments
 * @property cenId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN Transit Router peer attachments IDs.
 * @property nameRegex
 * @property names A list of CEN Transit Router peer attachments names.
 * @property outputFile
 * @property status The status of the transit router attachment.
 * @property transitRouterAttachmentId ID of the transit router attachment.
 * @property transitRouterId ID of the transit router.
 */
public data class GetTransitRouterPeerAttachmentsResult(
    public val attachments: List<GetTransitRouterPeerAttachmentsAttachment>,
    public val cenId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterPeerAttachmentsResult): GetTransitRouterPeerAttachmentsResult = GetTransitRouterPeerAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterPeerAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            cenId = javaType.cenId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterAttachmentId = javaType.transitRouterAttachmentId().map({ args0 ->
                args0
            }).orElse(null),
            transitRouterId = javaType.transitRouterId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
