@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Cen Transit Router Prefix List Association. It formats as `<prefix_list_id>:<transit_router_id>:<transit_router_table_id>:<next_hop>`.
 * @property nextHop The ID of the next hop connection.
 * @property nextHopInstanceId The ID of the network instance associated with the next hop connection.
 * @property nextHopType The type of the next hop.
 * @property ownerUid The ID of the Alibaba Cloud account to which the prefix list belongs.
 * @property prefixListId The ID of the prefix list.
 * @property status The status of the prefix list.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterTableId The ID of the route table of the transit router.
 */
public data class GetTransitRouterPrefixListAssociationsAssociation(
    public val id: String,
    public val nextHop: String,
    public val nextHopInstanceId: String,
    public val nextHopType: String,
    public val ownerUid: Int,
    public val prefixListId: String,
    public val status: String,
    public val transitRouterId: String,
    public val transitRouterTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterPrefixListAssociationsAssociation): GetTransitRouterPrefixListAssociationsAssociation =
            GetTransitRouterPrefixListAssociationsAssociation(
                id = javaType.id(),
                nextHop = javaType.nextHop(),
                nextHopInstanceId = javaType.nextHopInstanceId(),
                nextHopType = javaType.nextHopType(),
                ownerUid = javaType.ownerUid(),
                prefixListId = javaType.prefixListId(),
                status = javaType.status(),
                transitRouterId = javaType.transitRouterId(),
                transitRouterTableId = javaType.transitRouterTableId(),
            )
    }
}
