@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterPrefixListAssociations.
 * @property associations
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property ownerUid
 * @property pageNumber
 * @property pageSize
 * @property prefixListId
 * @property status
 * @property transitRouterId
 * @property transitRouterTableId
 */
public data class GetTransitRouterPrefixListAssociationsResult(
    public val associations: List<GetTransitRouterPrefixListAssociationsAssociation>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val ownerUid: Int? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val prefixListId: String? = null,
    public val status: String? = null,
    public val transitRouterId: String,
    public val transitRouterTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterPrefixListAssociationsResult): GetTransitRouterPrefixListAssociationsResult = GetTransitRouterPrefixListAssociationsResult(
            associations = javaType.associations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterPrefixListAssociationsAssociation.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            ownerUid = javaType.ownerUid().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            prefixListId = javaType.prefixListId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterId = javaType.transitRouterId(),
            transitRouterTableId = javaType.transitRouterTableId(),
        )
    }
}
