@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id
 * @property status
 * @property transitRouterRouteEntryDescription
 * @property transitRouterRouteEntryDestinationCidrBlock The target network segment of the route entry.
 * @property transitRouterRouteEntryId
 * @property transitRouterRouteEntryName
 * @property transitRouterRouteEntryNextHopId ID of the next hop.
 * @property transitRouterRouteEntryNextHopType Type of the next hop.
 * @property transitRouterRouteEntryType Type of the route entry.
 */
public data class GetTransitRouterRouteEntriesEntry(
    public val id: String,
    public val status: String,
    public val transitRouterRouteEntryDescription: String,
    public val transitRouterRouteEntryDestinationCidrBlock: String,
    public val transitRouterRouteEntryId: String,
    public val transitRouterRouteEntryName: String,
    public val transitRouterRouteEntryNextHopId: String,
    public val transitRouterRouteEntryNextHopType: String,
    public val transitRouterRouteEntryType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterRouteEntriesEntry): GetTransitRouterRouteEntriesEntry = GetTransitRouterRouteEntriesEntry(
            id = javaType.id(),
            status = javaType.status(),
            transitRouterRouteEntryDescription = javaType.transitRouterRouteEntryDescription(),
            transitRouterRouteEntryDestinationCidrBlock = javaType.transitRouterRouteEntryDestinationCidrBlock(),
            transitRouterRouteEntryId = javaType.transitRouterRouteEntryId(),
            transitRouterRouteEntryName = javaType.transitRouterRouteEntryName(),
            transitRouterRouteEntryNextHopId = javaType.transitRouterRouteEntryNextHopId(),
            transitRouterRouteEntryNextHopType = javaType.transitRouterRouteEntryNextHopType(),
            transitRouterRouteEntryType = javaType.transitRouterRouteEntryType(),
        )
    }
}
