@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterRouteEntries.
 * @property entries A list of CEN Route Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN Transit Router Route Entry IDs.
 * @property nameRegex
 * @property names A list of CEN Transit Router Route Entry Names.
 * @property outputFile
 * @property status
 * @property transitRouterRouteEntryIds
 * @property transitRouterRouteEntryNames
 * @property transitRouterRouteEntryStatus The status of the route entry in CEN.
 * @property transitRouterRouteTableId
 */
public data class GetTransitRouterRouteEntriesResult(
    public val entries: List<GetTransitRouterRouteEntriesEntry>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterRouteEntryIds: List<String>? = null,
    public val transitRouterRouteEntryNames: List<String>? = null,
    public val transitRouterRouteEntryStatus: String? = null,
    public val transitRouterRouteTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterRouteEntriesResult): GetTransitRouterRouteEntriesResult = GetTransitRouterRouteEntriesResult(
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteEntriesEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterRouteEntryIds = javaType.transitRouterRouteEntryIds().map({ args0 -> args0 }),
            transitRouterRouteEntryNames = javaType.transitRouterRouteEntryNames().map({ args0 -> args0 }),
            transitRouterRouteEntryStatus = javaType.transitRouterRouteEntryStatus().map({ args0 ->
                args0
            }).orElse(null),
            transitRouterRouteTableId = javaType.transitRouterRouteTableId(),
        )
    }
}
