@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id
 * @property resourceId ID of the transit router route table association.
 * @property resourceType Type of the resource.
 * @property status The status of the route table, including `Active`, `Associating`, `Dissociating`.
 * @property transitRouterAttachmentId The ID of the network instance connection.
 * @property transitRouterRouteTableId The ID of the route table of the Enterprise Edition transit router.
 */
public data class GetTransitRouterRouteTableAssociationsAssociation(
    public val id: String,
    public val resourceId: String,
    public val resourceType: String,
    public val status: String,
    public val transitRouterAttachmentId: String,
    public val transitRouterRouteTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterRouteTableAssociationsAssociation): GetTransitRouterRouteTableAssociationsAssociation =
            GetTransitRouterRouteTableAssociationsAssociation(
                id = javaType.id(),
                resourceId = javaType.resourceId(),
                resourceType = javaType.resourceType(),
                status = javaType.status(),
                transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
                transitRouterRouteTableId = javaType.transitRouterRouteTableId(),
            )
    }
}
