@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterRouteTableAssociations.
 * @property associations A list of CEN Transit Router Route Table Associations. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN Transit Router Route Table Association IDs.
 * @property outputFile
 * @property status The status of the route table.
 * @property transitRouterAttachmentId ID of the transit router attachment.
 * @property transitRouterAttachmentResourceId
 * @property transitRouterAttachmentResourceType
 * @property transitRouterRouteTableId ID of the transit router route table.
 */
public data class GetTransitRouterRouteTableAssociationsResult(
    public val associations: List<GetTransitRouterRouteTableAssociationsAssociation>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterAttachmentResourceId: String? = null,
    public val transitRouterAttachmentResourceType: String? = null,
    public val transitRouterRouteTableId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterRouteTableAssociationsResult): GetTransitRouterRouteTableAssociationsResult = GetTransitRouterRouteTableAssociationsResult(
            associations = javaType.associations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTableAssociationsAssociation.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterAttachmentId = javaType.transitRouterAttachmentId().map({ args0 ->
                args0
            }).orElse(null),
            transitRouterAttachmentResourceId = javaType.transitRouterAttachmentResourceId().map({ args0 ->
                args0
            }).orElse(null),
            transitRouterAttachmentResourceType = javaType.transitRouterAttachmentResourceType().map({ args0 ->
                args0
            }).orElse(null),
            transitRouterRouteTableId = javaType.transitRouterRouteTableId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
