@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterRouteTablePropagations.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN Transit Router Route Table Association IDs.
 * @property outputFile
 * @property propagations A list of CEN Transit Router Route Table Propagations. Each element contains the following attributes:
 * @property status The status of the route table.
 * @property transitRouterRouteTableId ID of the transit router route table.
 */
public data class GetTransitRouterRouteTablePropagationsResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val propagations: List<GetTransitRouterRouteTablePropagationsPropagation>,
    public val status: String? = null,
    public val transitRouterRouteTableId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterRouteTablePropagationsResult): GetTransitRouterRouteTablePropagationsResult = GetTransitRouterRouteTablePropagationsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            propagations = javaType.propagations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTablePropagationsPropagation.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterRouteTableId = javaType.transitRouterRouteTableId(),
        )
    }
}
