@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterRouteTables.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN Transit Router Route Table IDs.
 * @property nameRegex
 * @property names A list of name of CEN Transit Router Route Tables.
 * @property outputFile
 * @property status
 * @property tables A list of CEN Route Entries. Each element contains the following attributes:
 * @property transitRouterId
 * @property transitRouterRouteTableIds
 * @property transitRouterRouteTableNames
 * @property transitRouterRouteTableStatus The status of the route table.
 */
public data class GetTransitRouterRouteTablesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tables: List<GetTransitRouterRouteTablesTable>,
    public val transitRouterId: String,
    public val transitRouterRouteTableIds: List<String>? = null,
    public val transitRouterRouteTableNames: List<String>? = null,
    public val transitRouterRouteTableStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterRouteTablesResult): GetTransitRouterRouteTablesResult = GetTransitRouterRouteTablesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tables = javaType.tables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterRouteTablesTable.Companion.toKotlin(args0)
                })
            }),
            transitRouterId = javaType.transitRouterId(),
            transitRouterRouteTableIds = javaType.transitRouterRouteTableIds().map({ args0 -> args0 }),
            transitRouterRouteTableNames = javaType.transitRouterRouteTableNames().map({ args0 -> args0 }),
            transitRouterRouteTableStatus = javaType.transitRouterRouteTableStatus().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
