@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoPublishRouteEnabled ID of the region where the conflicted VBR is located.
 * @property id
 * @property resourceType Type of the resource.
 * @property status The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
 * @property transitRouterAttachmentDescription
 * @property transitRouterAttachmentId ID of the transit router VBR attachment.
 * @property transitRouterAttachmentName Name of the transit router attachment.
 * @property vbrId ID of the VBR.
 * @property vbrOwnerId The Owner ID of the VBR.
 */
public data class GetTransitRouterVbrAttachmentsAttachment(
    public val autoPublishRouteEnabled: Boolean,
    public val id: String,
    public val resourceType: String,
    public val status: String,
    public val transitRouterAttachmentDescription: String,
    public val transitRouterAttachmentId: String,
    public val transitRouterAttachmentName: String,
    public val vbrId: String,
    public val vbrOwnerId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterVbrAttachmentsAttachment): GetTransitRouterVbrAttachmentsAttachment = GetTransitRouterVbrAttachmentsAttachment(
            autoPublishRouteEnabled = javaType.autoPublishRouteEnabled(),
            id = javaType.id(),
            resourceType = javaType.resourceType(),
            status = javaType.status(),
            transitRouterAttachmentDescription = javaType.transitRouterAttachmentDescription(),
            transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
            transitRouterAttachmentName = javaType.transitRouterAttachmentName(),
            vbrId = javaType.vbrId(),
            vbrOwnerId = javaType.vbrOwnerId(),
        )
    }
}
