@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterVbrAttachments.
 * @property attachments A list of CEN Transit Router VBR Attachments. Each element contains the following attributes:
 * @property cenId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN Transit Router VBR attachment IDs.
 * @property outputFile
 * @property status The status of the transit router attachment.
 * @property transitRouterId
 */
public data class GetTransitRouterVbrAttachmentsResult(
    public val attachments: List<GetTransitRouterVbrAttachmentsAttachment>,
    public val cenId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterVbrAttachmentsResult): GetTransitRouterVbrAttachmentsResult = GetTransitRouterVbrAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVbrAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            cenId = javaType.cenId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterId = javaType.transitRouterId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
