@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoPublishRouteEnabled (Available since v1.224.0) Whether the transit router is automatically published to the VPC instance.
 * @property cenId The ID of the CEN instance.
 * @property id
 * @property paymentType The payment type of the resource.
 * @property resourceType The resource type of the Transit Router VPC Attachment.
 * @property status The status of the Transit Router VPC Attachment. Valid Values: `Attached`, `Attaching`, `Detaching`.
 * @property transitRouterAttachmentDescription The description of the Transit Router VPC Attachment.
 * @property transitRouterAttachmentId The ID of the Transit Router VPC Attachment.
 * @property transitRouterAttachmentName The name of the Transit Router VPC Attachment.
 * @property transitRouterId The ID of the transit router.
 * @property vpcId The ID of the VPC.
 * @property vpcOwnerId The Owner ID of the VPC.
 * @property zoneMappings The list of zone mapping of the VPC.
 */
public data class GetTransitRouterVpcAttachmentsAttachment(
    public val autoPublishRouteEnabled: Boolean,
    public val cenId: String,
    public val id: String,
    public val paymentType: String,
    public val resourceType: String,
    public val status: String,
    public val transitRouterAttachmentDescription: String,
    public val transitRouterAttachmentId: String,
    public val transitRouterAttachmentName: String,
    public val transitRouterId: String,
    public val vpcId: String,
    public val vpcOwnerId: String,
    public val zoneMappings: List<GetTransitRouterVpcAttachmentsAttachmentZoneMapping>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterVpcAttachmentsAttachment): GetTransitRouterVpcAttachmentsAttachment = GetTransitRouterVpcAttachmentsAttachment(
            autoPublishRouteEnabled = javaType.autoPublishRouteEnabled(),
            cenId = javaType.cenId(),
            id = javaType.id(),
            paymentType = javaType.paymentType(),
            resourceType = javaType.resourceType(),
            status = javaType.status(),
            transitRouterAttachmentDescription = javaType.transitRouterAttachmentDescription(),
            transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
            transitRouterAttachmentName = javaType.transitRouterAttachmentName(),
            transitRouterId = javaType.transitRouterId(),
            vpcId = javaType.vpcId(),
            vpcOwnerId = javaType.vpcOwnerId(),
            zoneMappings = javaType.zoneMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVpcAttachmentsAttachmentZoneMapping.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
