@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouterVpcAttachments.
 * @property attachments A list of Transit Router VPC Attachments. Each element contains the following attributes:
 * @property cenId (Available since v1.224.0) The ID of the CEN instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Transit Router VPC Attachment names.
 * @property outputFile
 * @property status The status of the Transit Router VPC Attachment.
 * @property transitRouterAttachmentId The ID of the Transit Router VPC Attachment.
 * @property transitRouterId (Available since v1.224.0) The ID of the transit router.
 * @property vpcId The ID of the VPC.
 */
public data class GetTransitRouterVpcAttachmentsResult(
    public val attachments: List<GetTransitRouterVpcAttachmentsAttachment>,
    public val cenId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterId: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterVpcAttachmentsResult): GetTransitRouterVpcAttachmentsResult = GetTransitRouterVpcAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVpcAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            cenId = javaType.cenId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterAttachmentId = javaType.transitRouterAttachmentId().map({ args0 ->
                args0
            }).orElse(null),
            transitRouterId = javaType.transitRouterId().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
