@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoPublishRouteEnabled Whether to allow the forwarding router instance to automatically publish routing entries to IPsec connections.
 * @property createTime The creation time of the resource.
 * @property id
 * @property resourceType Type of the resource.
 * @property status The status of the transit router attachment.
 * @property transitRouterAttachmentDescription The description of the VPN connection.
 * @property transitRouterAttachmentId
 * @property transitRouterAttachmentName The name of the VPN connection.
 * @property transitRouterId The ID of the forwarding router instance.
 * @property vpnId The id of the vpn.
 * @property vpnOwnerId The owner id of vpn.
 * @property zones The list of zone mapping.
 */
public data class GetTransitRouterVpnAttachmentsAttachment(
    public val autoPublishRouteEnabled: Boolean,
    public val createTime: String,
    public val id: String,
    public val resourceType: String,
    public val status: String,
    public val transitRouterAttachmentDescription: String,
    public val transitRouterAttachmentId: String,
    public val transitRouterAttachmentName: String,
    public val transitRouterId: String,
    public val vpnId: String,
    public val vpnOwnerId: String,
    public val zones: List<GetTransitRouterVpnAttachmentsAttachmentZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRouterVpnAttachmentsAttachment): GetTransitRouterVpnAttachmentsAttachment = GetTransitRouterVpnAttachmentsAttachment(
            autoPublishRouteEnabled = javaType.autoPublishRouteEnabled(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            resourceType = javaType.resourceType(),
            status = javaType.status(),
            transitRouterAttachmentDescription = javaType.transitRouterAttachmentDescription(),
            transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
            transitRouterAttachmentName = javaType.transitRouterAttachmentName(),
            transitRouterId = javaType.transitRouterId(),
            vpnId = javaType.vpnId(),
            vpnOwnerId = javaType.vpnOwnerId(),
            zones = javaType.zones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRouterVpnAttachmentsAttachmentZone.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
