@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTransitRouters.
 * @property cenId The ID of the CEN instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of  CEN Transit Routers names.
 * @property outputFile
 * @property status The status of the transit router attachment.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterIds
 * @property transitRouters A list of CEN Transit Routers. Each element contains the following attributes:
 */
public data class GetTransitRoutersResult(
    public val cenId: String,
    public val id: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String? = null,
    public val transitRouterIds: List<String>? = null,
    public val transitRouters: List<GetTransitRoutersTransitRouter>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRoutersResult): GetTransitRoutersResult = GetTransitRoutersResult(
            cenId = javaType.cenId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            transitRouterId = javaType.transitRouterId().map({ args0 -> args0 }).orElse(null),
            transitRouterIds = javaType.transitRouterIds().map({ args0 -> args0 }),
            transitRouters = javaType.transitRouters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetTransitRoutersTransitRouter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
