@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aliUid The UID of the Aliyun.
 * @property cenId The ID of the CEN instance.
 * @property id The ID of the resource, It is formatted to `<cen_id>:<transit_router_id>`. **NOTE:** Before 1.151.0, It is formatted to `<transit_router_id>`.
 * @property status The status of the resource. Valid values `Active`, `Creating`, `Deleting` and `Updating`.
 * @property transitRouterDescription The description of the transit router.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterName The name of the transit router.
 * @property type The Type of the transit router.
 * @property xgwVip The vip of the XGW.
 */
public data class GetTransitRoutersTransitRouter(
    public val aliUid: String,
    public val cenId: String,
    public val id: String,
    public val status: String,
    public val transitRouterDescription: String,
    public val transitRouterId: String,
    public val transitRouterName: String,
    public val type: String,
    public val xgwVip: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetTransitRoutersTransitRouter): GetTransitRoutersTransitRouter = GetTransitRoutersTransitRouter(
            aliUid = javaType.aliUid(),
            cenId = javaType.cenId(),
            id = javaType.id(),
            status = javaType.status(),
            transitRouterDescription = javaType.transitRouterDescription(),
            transitRouterId = javaType.transitRouterId(),
            transitRouterName = javaType.transitRouterName(),
            type = javaType.type(),
            xgwVip = javaType.xgwVip(),
        )
    }
}
