@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cenId The ID of the Cloud Enterprise Network (CEN) instance.
 * @property healthCheckInterval The time interval at which probe packets are sent during the health check.
 * @property healthCheckSourceIp The source IP address of the health check.
 * @property healthCheckTargetIp The destination IP address of the health check.
 * @property healthyThreshold The number of probe packets that are sent during the health check.
 * @property id The ID of the CEN VBR Heath Check.
 * @property vbrInstanceId The ID of the VBR instance.
 * @property vbrInstanceRegionId The ID of the region where the VBR instance is deployed.
 */
public data class GetVbrHealthChecksCheck(
    public val cenId: String,
    public val healthCheckInterval: Int,
    public val healthCheckSourceIp: String,
    public val healthCheckTargetIp: String,
    public val healthyThreshold: Int,
    public val id: String,
    public val vbrInstanceId: String,
    public val vbrInstanceRegionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetVbrHealthChecksCheck): GetVbrHealthChecksCheck = GetVbrHealthChecksCheck(
            cenId = javaType.cenId(),
            healthCheckInterval = javaType.healthCheckInterval(),
            healthCheckSourceIp = javaType.healthCheckSourceIp(),
            healthCheckTargetIp = javaType.healthCheckTargetIp(),
            healthyThreshold = javaType.healthyThreshold(),
            id = javaType.id(),
            vbrInstanceId = javaType.vbrInstanceId(),
            vbrInstanceRegionId = javaType.vbrInstanceRegionId(),
        )
    }
}
