@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVbrHealthChecks.
 * @property cenId The ID of the Cloud Enterprise Network (CEN) instance.
 * @property checks A list of CEN VBR Heath Checks. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of the CEN VBR Heath Check IDs.
 * @property outputFile
 * @property vbrInstanceId The ID of the VBR instance.
 * @property vbrInstanceOwnerId
 * @property vbrInstanceRegionId The ID of the region where the VBR instance is deployed.
 */
public data class GetVbrHealthChecksResult(
    public val cenId: String? = null,
    public val checks: List<GetVbrHealthChecksCheck>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val vbrInstanceId: String? = null,
    public val vbrInstanceOwnerId: Int? = null,
    public val vbrInstanceRegionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetVbrHealthChecksResult): GetVbrHealthChecksResult = GetVbrHealthChecksResult(
            cenId = javaType.cenId().map({ args0 -> args0 }).orElse(null),
            checks = javaType.checks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetVbrHealthChecksCheck.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            vbrInstanceId = javaType.vbrInstanceId().map({ args0 -> args0 }).orElse(null),
            vbrInstanceOwnerId = javaType.vbrInstanceOwnerId().map({ args0 -> args0 }).orElse(null),
            vbrInstanceRegionId = javaType.vbrInstanceRegionId(),
        )
    }
}
