@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cfg.kotlin

import com.pulumi.alicloud.cfg.kotlin.outputs.AggregateCompliancePackConfigRule
import com.pulumi.alicloud.cfg.kotlin.outputs.AggregateCompliancePackConfigRuleId
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cfg.kotlin.outputs.AggregateCompliancePackConfigRule.Companion.toKotlin as aggregateCompliancePackConfigRuleToKotlin
import com.pulumi.alicloud.cfg.kotlin.outputs.AggregateCompliancePackConfigRuleId.Companion.toKotlin as aggregateCompliancePackConfigRuleIdToKotlin

/**
 * Builder for [AggregateCompliancePack].
 */
@PulumiTagMarker
public class AggregateCompliancePackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AggregateCompliancePackArgs = AggregateCompliancePackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AggregateCompliancePackArgsBuilder.() -> Unit) {
        val builder = AggregateCompliancePackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AggregateCompliancePack {
        val builtJavaResource = com.pulumi.alicloud.cfg.AggregateCompliancePack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AggregateCompliancePack(builtJavaResource)
    }
}

/**
 * Provides a Cloud Config Aggregate Compliance Pack resource.
 * For information about Cloud Config Aggregate Compliance Pack and how to use it, see [What is Aggregate Compliance Pack](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createaggregatecompliancepack).
 * > **NOTE:** Available since v1.124.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform_example";
 * const default = alicloud.resourcemanager.getAccounts({
 *     status: "CreateSuccess",
 * });
 * const defaultAggregator = new alicloud.cfg.Aggregator("default", {
 *     aggregatorAccounts: [{
 *         accountId: _default.then(_default => _default.accounts?.[0]?.accountId),
 *         accountName: _default.then(_default => _default.accounts?.[0]?.displayName),
 *         accountType: "ResourceDirectory",
 *     }],
 *     aggregatorName: name,
 *     description: name,
 *     aggregatorType: "CUSTOM",
 * });
 * const defaultAggregateConfigRule = new alicloud.cfg.AggregateConfigRule("default", {
 *     aggregateConfigRuleName: "contains-tag",
 *     aggregatorId: defaultAggregator.id,
 *     configRuleTriggerTypes: "ConfigurationItemChangeNotification",
 *     sourceOwner: "ALIYUN",
 *     sourceIdentifier: "contains-tag",
 *     description: name,
 *     riskLevel: 1,
 *     resourceTypesScopes: ["ACS::ECS::Instance"],
 *     inputParameters: {
 *         key: "example",
 *         value: "example",
 *     },
 * });
 * const defaultAggregateCompliancePack = new alicloud.cfg.AggregateCompliancePack("default", {
 *     aggregateCompliancePackName: name,
 *     aggregatorId: defaultAggregator.id,
 *     description: name,
 *     riskLevel: 1,
 *     configRuleIds: [{
 *         configRuleId: defaultAggregateConfigRule.configRuleId,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform_example"
 * default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
 * default_aggregator = alicloud.cfg.Aggregator("default",
 *     aggregator_accounts=[{
 *         "account_id": default.accounts[0].account_id,
 *         "account_name": default.accounts[0].display_name,
 *         "account_type": "ResourceDirectory",
 *     }],
 *     aggregator_name=name,
 *     description=name,
 *     aggregator_type="CUSTOM")
 * default_aggregate_config_rule = alicloud.cfg.AggregateConfigRule("default",
 *     aggregate_config_rule_name="contains-tag",
 *     aggregator_id=default_aggregator.id,
 *     config_rule_trigger_types="ConfigurationItemChangeNotification",
 *     source_owner="ALIYUN",
 *     source_identifier="contains-tag",
 *     description=name,
 *     risk_level=1,
 *     resource_types_scopes=["ACS::ECS::Instance"],
 *     input_parameters={
 *         "key": "example",
 *         "value": "example",
 *     })
 * default_aggregate_compliance_pack = alicloud.cfg.AggregateCompliancePack("default",
 *     aggregate_compliance_pack_name=name,
 *     aggregator_id=default_aggregator.id,
 *     description=name,
 *     risk_level=1,
 *     config_rule_ids=[{
 *         "config_rule_id": default_aggregate_config_rule.config_rule_id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform_example";
 *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke(new()
 *     {
 *         Status = "CreateSuccess",
 *     });
 *     var defaultAggregator = new AliCloud.Cfg.Aggregator("default", new()
 *     {
 *         AggregatorAccounts = new[]
 *         {
 *             new AliCloud.Cfg.Inputs.AggregatorAggregatorAccountArgs
 *             {
 *                 AccountId = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.AccountId)),
 *                 AccountName = @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Accounts[0]?.DisplayName)),
 *                 AccountType = "ResourceDirectory",
 *             },
 *         },
 *         AggregatorName = name,
 *         Description = name,
 *         AggregatorType = "CUSTOM",
 *     });
 *     var defaultAggregateConfigRule = new AliCloud.Cfg.AggregateConfigRule("default", new()
 *     {
 *         AggregateConfigRuleName = "contains-tag",
 *         AggregatorId = defaultAggregator.Id,
 *         ConfigRuleTriggerTypes = "ConfigurationItemChangeNotification",
 *         SourceOwner = "ALIYUN",
 *         SourceIdentifier = "contains-tag",
 *         Description = name,
 *         RiskLevel = 1,
 *         ResourceTypesScopes = new[]
 *         {
 *             "ACS::ECS::Instance",
 *         },
 *         InputParameters =
 *         {
 *             { "key", "example" },
 *             { "value", "example" },
 *         },
 *     });
 *     var defaultAggregateCompliancePack = new AliCloud.Cfg.AggregateCompliancePack("default", new()
 *     {
 *         AggregateCompliancePackName = name,
 *         AggregatorId = defaultAggregator.Id,
 *         Description = name,
 *         RiskLevel = 1,
 *         ConfigRuleIds = new[]
 *         {
 *             new AliCloud.Cfg.Inputs.AggregateCompliancePackConfigRuleIdArgs
 *             {
 *                 ConfigRuleId = defaultAggregateConfigRule.ConfigRuleId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cfg"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetAccounts(ctx, &resourcemanager.GetAccountsArgs{
 * 			Status: pulumi.StringRef("CreateSuccess"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAggregator, err := cfg.NewAggregator(ctx, "default", &cfg.AggregatorArgs{
 * 			AggregatorAccounts: cfg.AggregatorAggregatorAccountArray{
 * 				&cfg.AggregatorAggregatorAccountArgs{
 * 					AccountId:   pulumi.String(_default.Accounts[0].AccountId),
 * 					AccountName: pulumi.String(_default.Accounts[0].DisplayName),
 * 					AccountType: pulumi.String("ResourceDirectory"),
 * 				},
 * 			},
 * 			AggregatorName: pulumi.String(name),
 * 			Description:    pulumi.String(name),
 * 			AggregatorType: pulumi.String("CUSTOM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAggregateConfigRule, err := cfg.NewAggregateConfigRule(ctx, "default", &cfg.AggregateConfigRuleArgs{
 * 			AggregateConfigRuleName: pulumi.String("contains-tag"),
 * 			AggregatorId:            defaultAggregator.ID(),
 * 			ConfigRuleTriggerTypes:  pulumi.String("ConfigurationItemChangeNotification"),
 * 			SourceOwner:             pulumi.String("ALIYUN"),
 * 			SourceIdentifier:        pulumi.String("contains-tag"),
 * 			Description:             pulumi.String(name),
 * 			RiskLevel:               pulumi.Int(1),
 * 			ResourceTypesScopes: pulumi.StringArray{
 * 				pulumi.String("ACS::ECS::Instance"),
 * 			},
 * 			InputParameters: pulumi.StringMap{
 * 				"key":   pulumi.String("example"),
 * 				"value": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cfg.NewAggregateCompliancePack(ctx, "default", &cfg.AggregateCompliancePackArgs{
 * 			AggregateCompliancePackName: pulumi.String(name),
 * 			AggregatorId:                defaultAggregator.ID(),
 * 			Description:                 pulumi.String(name),
 * 			RiskLevel:                   pulumi.Int(1),
 * 			ConfigRuleIds: cfg.AggregateCompliancePackConfigRuleIdArray{
 * 				&cfg.AggregateCompliancePackConfigRuleIdArgs{
 * 					ConfigRuleId: defaultAggregateConfigRule.ConfigRuleId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
 * import com.pulumi.alicloud.cfg.Aggregator;
 * import com.pulumi.alicloud.cfg.AggregatorArgs;
 * import com.pulumi.alicloud.cfg.inputs.AggregatorAggregatorAccountArgs;
 * import com.pulumi.alicloud.cfg.AggregateConfigRule;
 * import com.pulumi.alicloud.cfg.AggregateConfigRuleArgs;
 * import com.pulumi.alicloud.cfg.AggregateCompliancePack;
 * import com.pulumi.alicloud.cfg.AggregateCompliancePackArgs;
 * import com.pulumi.alicloud.cfg.inputs.AggregateCompliancePackConfigRuleIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform_example");
 *         final var default = ResourcemanagerFunctions.getAccounts(GetAccountsArgs.builder()
 *             .status("CreateSuccess")
 *             .build());
 *         var defaultAggregator = new Aggregator("defaultAggregator", AggregatorArgs.builder()
 *             .aggregatorAccounts(AggregatorAggregatorAccountArgs.builder()
 *                 .accountId(default_.accounts()[0].accountId())
 *                 .accountName(default_.accounts()[0].displayName())
 *                 .accountType("ResourceDirectory")
 *                 .build())
 *             .aggregatorName(name)
 *             .description(name)
 *             .aggregatorType("CUSTOM")
 *             .build());
 *         var defaultAggregateConfigRule = new AggregateConfigRule("defaultAggregateConfigRule", AggregateConfigRuleArgs.builder()
 *             .aggregateConfigRuleName("contains-tag")
 *             .aggregatorId(defaultAggregator.id())
 *             .configRuleTriggerTypes("ConfigurationItemChangeNotification")
 *             .sourceOwner("ALIYUN")
 *             .sourceIdentifier("contains-tag")
 *             .description(name)
 *             .riskLevel(1)
 *             .resourceTypesScopes("ACS::ECS::Instance")
 *             .inputParameters(Map.ofEntries(
 *                 Map.entry("key", "example"),
 *                 Map.entry("value", "example")
 *             ))
 *             .build());
 *         var defaultAggregateCompliancePack = new AggregateCompliancePack("defaultAggregateCompliancePack", AggregateCompliancePackArgs.builder()
 *             .aggregateCompliancePackName(name)
 *             .aggregatorId(defaultAggregator.id())
 *             .description(name)
 *             .riskLevel(1)
 *             .configRuleIds(AggregateCompliancePackConfigRuleIdArgs.builder()
 *                 .configRuleId(defaultAggregateConfigRule.configRuleId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform_example
 * resources:
 *   defaultAggregator:
 *     type: alicloud:cfg:Aggregator
 *     name: default
 *     properties:
 *       aggregatorAccounts:
 *         - accountId: ${default.accounts[0].accountId}
 *           accountName: ${default.accounts[0].displayName}
 *           accountType: ResourceDirectory
 *       aggregatorName: ${name}
 *       description: ${name}
 *       aggregatorType: CUSTOM
 *   defaultAggregateConfigRule:
 *     type: alicloud:cfg:AggregateConfigRule
 *     name: default
 *     properties:
 *       aggregateConfigRuleName: contains-tag
 *       aggregatorId: ${defaultAggregator.id}
 *       configRuleTriggerTypes: ConfigurationItemChangeNotification
 *       sourceOwner: ALIYUN
 *       sourceIdentifier: contains-tag
 *       description: ${name}
 *       riskLevel: 1
 *       resourceTypesScopes:
 *         - ACS::ECS::Instance
 *       inputParameters:
 *         key: example
 *         value: example
 *   defaultAggregateCompliancePack:
 *     type: alicloud:cfg:AggregateCompliancePack
 *     name: default
 *     properties:
 *       aggregateCompliancePackName: ${name}
 *       aggregatorId: ${defaultAggregator.id}
 *       description: ${name}
 *       riskLevel: 1
 *       configRuleIds:
 *         - configRuleId: ${defaultAggregateConfigRule.configRuleId}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getAccounts
 *       Arguments:
 *         status: CreateSuccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Config Aggregate Compliance Pack can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cfg/aggregateCompliancePack:AggregateCompliancePack example <aggregator_id>:<aggregator_compliance_pack_id>
 * ```
 */
public class AggregateCompliancePack internal constructor(
    override val javaResource: com.pulumi.alicloud.cfg.AggregateCompliancePack,
) : KotlinCustomResource(javaResource, AggregateCompliancePackMapper) {
    /**
     * The name of compliance package name. **NOTE:** From version 1.145.0, `aggregate_compliance_pack_name` can be modified.
     */
    public val aggregateCompliancePackName: Output<String>
        get() = javaResource.aggregateCompliancePackName().applyValue({ args0 -> args0 })

    /**
     * The ID of the compliance package.
     */
    public val aggregatorCompliancePackId: Output<String>
        get() = javaResource.aggregatorCompliancePackId().applyValue({ args0 -> args0 })

    /**
     * The ID of aggregator.
     */
    public val aggregatorId: Output<String>
        get() = javaResource.aggregatorId().applyValue({ args0 -> args0 })

    /**
     * The Template ID of compliance package.
     */
    public val compliancePackTemplateId: Output<String>?
        get() = javaResource.compliancePackTemplateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of Config Rule IDs. See `config_rule_ids` below.
     */
    public val configRuleIds: Output<List<AggregateCompliancePackConfigRuleId>>?
        get() = javaResource.configRuleIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        aggregateCompliancePackConfigRuleIdToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A list of Config Rules. See `config_rules` below. **NOTE:** Field `config_rules` has been deprecated from provider version 1.141.0. New field `config_rule_ids` instead.
     */
    @Deprecated(
        message = """
  Field `config_rules` has been deprecated from provider version 1.141.0. New field
      `config_rule_ids` instead.
  """,
    )
    public val configRules: Output<List<AggregateCompliancePackConfigRule>>?
        get() = javaResource.configRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> aggregateCompliancePackConfigRuleToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The description of compliance package.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The Risk Level. Valid values:
     */
    public val riskLevel: Output<Int>
        get() = javaResource.riskLevel().applyValue({ args0 -> args0 })

    /**
     * The status of the Aggregate Compliance Pack.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AggregateCompliancePackMapper : ResourceMapper<AggregateCompliancePack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cfg.AggregateCompliancePack::class == javaResource::class

    override fun map(javaResource: Resource): AggregateCompliancePack =
        AggregateCompliancePack(javaResource as com.pulumi.alicloud.cfg.AggregateCompliancePack)
}

/**
 * @see [AggregateCompliancePack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AggregateCompliancePack].
 */
public suspend fun aggregateCompliancePack(
    name: String,
    block: suspend AggregateCompliancePackResourceBuilder.() -> Unit,
): AggregateCompliancePack {
    val builder = AggregateCompliancePackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AggregateCompliancePack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun aggregateCompliancePack(name: String): AggregateCompliancePack {
    val builder = AggregateCompliancePackResourceBuilder()
    builder.name(name)
    return builder.build()
}
